/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EndianUtils {
    public static short swapShort(short value2) {
        return (short)(((value2 >> 0 & 0xFF) << 8) + ((value2 >> 8 & 0xFF) << 0));
    }

    public static int swapInteger(int value2) {
        return ((value2 >> 0 & 0xFF) << 24) + ((value2 >> 8 & 0xFF) << 16) + ((value2 >> 16 & 0xFF) << 8) + ((value2 >> 24 & 0xFF) << 0);
    }

    public static long swapLong(long value2) {
        return ((value2 >> 0 & 0xFFL) << 56) + ((value2 >> 8 & 0xFFL) << 48) + ((value2 >> 16 & 0xFFL) << 40) + ((value2 >> 24 & 0xFFL) << 32) + ((value2 >> 32 & 0xFFL) << 24) + ((value2 >> 40 & 0xFFL) << 16) + ((value2 >> 48 & 0xFFL) << 8) + ((value2 >> 56 & 0xFFL) << 0);
    }

    public static float swapFloat(float value2) {
        return Float.intBitsToFloat(EndianUtils.swapInteger(Float.floatToIntBits(value2)));
    }

    public static double swapDouble(double value2) {
        return Double.longBitsToDouble(EndianUtils.swapLong(Double.doubleToLongBits(value2)));
    }

    public static void writeSwappedShort(byte[] data, int offset, short value2) {
        data[offset + 0] = (byte)(value2 >> 0 & 0xFF);
        data[offset + 1] = (byte)(value2 >> 8 & 0xFF);
    }

    public static short readSwappedShort(byte[] data, int offset) {
        return (short)(((data[offset + 0] & 0xFF) << 0) + ((data[offset + 1] & 0xFF) << 8));
    }

    public static int readSwappedUnsignedShort(byte[] data, int offset) {
        return ((data[offset + 0] & 0xFF) << 0) + ((data[offset + 1] & 0xFF) << 8);
    }

    public static void writeSwappedInteger(byte[] data, int offset, int value2) {
        data[offset + 0] = (byte)(value2 >> 0 & 0xFF);
        data[offset + 1] = (byte)(value2 >> 8 & 0xFF);
        data[offset + 2] = (byte)(value2 >> 16 & 0xFF);
        data[offset + 3] = (byte)(value2 >> 24 & 0xFF);
    }

    public static int readSwappedInteger(byte[] data, int offset) {
        return ((data[offset + 0] & 0xFF) << 0) + ((data[offset + 1] & 0xFF) << 8) + ((data[offset + 2] & 0xFF) << 16) + ((data[offset + 3] & 0xFF) << 24);
    }

    public static long readSwappedUnsignedInteger(byte[] data, int offset) {
        long low = ((data[offset + 0] & 0xFF) << 0) + ((data[offset + 1] & 0xFF) << 8) + ((data[offset + 2] & 0xFF) << 16);
        long high = data[offset + 3] & 0xFF;
        return (high << 24) + (0xFFFFFFFFL & low);
    }

    public static void writeSwappedLong(byte[] data, int offset, long value2) {
        data[offset + 0] = (byte)(value2 >> 0 & 0xFFL);
        data[offset + 1] = (byte)(value2 >> 8 & 0xFFL);
        data[offset + 2] = (byte)(value2 >> 16 & 0xFFL);
        data[offset + 3] = (byte)(value2 >> 24 & 0xFFL);
        data[offset + 4] = (byte)(value2 >> 32 & 0xFFL);
        data[offset + 5] = (byte)(value2 >> 40 & 0xFFL);
        data[offset + 6] = (byte)(value2 >> 48 & 0xFFL);
        data[offset + 7] = (byte)(value2 >> 56 & 0xFFL);
    }

    public static long readSwappedLong(byte[] data, int offset) {
        long low = ((data[offset + 0] & 0xFF) << 0) + ((data[offset + 1] & 0xFF) << 8) + ((data[offset + 2] & 0xFF) << 16) + ((data[offset + 3] & 0xFF) << 24);
        long high = ((data[offset + 4] & 0xFF) << 0) + ((data[offset + 5] & 0xFF) << 8) + ((data[offset + 6] & 0xFF) << 16) + ((data[offset + 7] & 0xFF) << 24);
        return (high << 32) + (0xFFFFFFFFL & low);
    }

    public static void writeSwappedFloat(byte[] data, int offset, float value2) {
        EndianUtils.writeSwappedInteger(data, offset, Float.floatToIntBits(value2));
    }

    public static float readSwappedFloat(byte[] data, int offset) {
        return Float.intBitsToFloat(EndianUtils.readSwappedInteger(data, offset));
    }

    public static void writeSwappedDouble(byte[] data, int offset, double value2) {
        EndianUtils.writeSwappedLong(data, offset, Double.doubleToLongBits(value2));
    }

    public static double readSwappedDouble(byte[] data, int offset) {
        return Double.longBitsToDouble(EndianUtils.readSwappedLong(data, offset));
    }

    public static void writeSwappedShort(OutputStream output, short value2) throws IOException {
        output.write((byte)(value2 >> 0 & 0xFF));
        output.write((byte)(value2 >> 8 & 0xFF));
    }

    public static short readSwappedShort(InputStream input2) throws IOException {
        return (short)(((EndianUtils.read(input2) & 0xFF) << 0) + ((EndianUtils.read(input2) & 0xFF) << 8));
    }

    public static int readSwappedUnsignedShort(InputStream input2) throws IOException {
        int value1 = EndianUtils.read(input2);
        int value2 = EndianUtils.read(input2);
        return ((value1 & 0xFF) << 0) + ((value2 & 0xFF) << 8);
    }

    public static void writeSwappedInteger(OutputStream output, int value2) throws IOException {
        output.write((byte)(value2 >> 0 & 0xFF));
        output.write((byte)(value2 >> 8 & 0xFF));
        output.write((byte)(value2 >> 16 & 0xFF));
        output.write((byte)(value2 >> 24 & 0xFF));
    }

    public static int readSwappedInteger(InputStream input2) throws IOException {
        int value1 = EndianUtils.read(input2);
        int value2 = EndianUtils.read(input2);
        int value3 = EndianUtils.read(input2);
        int value4 = EndianUtils.read(input2);
        return ((value1 & 0xFF) << 0) + ((value2 & 0xFF) << 8) + ((value3 & 0xFF) << 16) + ((value4 & 0xFF) << 24);
    }

    public static long readSwappedUnsignedInteger(InputStream input2) throws IOException {
        int value1 = EndianUtils.read(input2);
        int value2 = EndianUtils.read(input2);
        int value3 = EndianUtils.read(input2);
        int value4 = EndianUtils.read(input2);
        long low = ((value1 & 0xFF) << 0) + ((value2 & 0xFF) << 8) + ((value3 & 0xFF) << 16);
        long high = value4 & 0xFF;
        return (high << 24) + (0xFFFFFFFFL & low);
    }

    public static void writeSwappedLong(OutputStream output, long value2) throws IOException {
        output.write((byte)(value2 >> 0 & 0xFFL));
        output.write((byte)(value2 >> 8 & 0xFFL));
        output.write((byte)(value2 >> 16 & 0xFFL));
        output.write((byte)(value2 >> 24 & 0xFFL));
        output.write((byte)(value2 >> 32 & 0xFFL));
        output.write((byte)(value2 >> 40 & 0xFFL));
        output.write((byte)(value2 >> 48 & 0xFFL));
        output.write((byte)(value2 >> 56 & 0xFFL));
    }

    public static long readSwappedLong(InputStream input2) throws IOException {
        byte[] bytes2 = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes2[i] = (byte)EndianUtils.read(input2);
        }
        return EndianUtils.readSwappedLong(bytes2, 0);
    }

    public static void writeSwappedFloat(OutputStream output, float value2) throws IOException {
        EndianUtils.writeSwappedInteger(output, Float.floatToIntBits(value2));
    }

    public static float readSwappedFloat(InputStream input2) throws IOException {
        return Float.intBitsToFloat(EndianUtils.readSwappedInteger(input2));
    }

    public static void writeSwappedDouble(OutputStream output, double value2) throws IOException {
        EndianUtils.writeSwappedLong(output, Double.doubleToLongBits(value2));
    }

    public static double readSwappedDouble(InputStream input2) throws IOException {
        return Double.longBitsToDouble(EndianUtils.readSwappedLong(input2));
    }

    private static int read(InputStream input2) throws IOException {
        int value2 = input2.read();
        if (-1 == value2) {
            throw new EOFException("Unexpected EOF reached");
        }
        return value2;
    }
}

